<?=$header?>
<?=$column_left?>
<div id="content">
    <style>
        .loader {
            display: inline-block;
            position: relative;
            width: 20px;
            height: 20px;
        }

        .loader div {
            display: inline-block;
            position: absolute;
            left: 8px;
            width: 16px;
            background: #fff;
            animation: loader 1.2s cubic-bezier(0, 0.25, 0.25, 1) infinite;
        }

        .loader div:nth-child(1) {
            left: 8px;
            animation-delay: -0.24s;
        }

        .loader div:nth-child(2) {
            left: 32px;
            animation-delay: -0.12s;
        }

        .loader div:nth-child(3) {
            left: 56px;
            animation-delay: 0;
        }

        @keyframes loader {
            0% {
                top: 2px;
                height: 16px;
            }
            50%, 100% {
                top: 6px;
                height: 8px;
            }
        }
    </style>
    <script>
        (function ($) {
            "use strict";

            $(document).on('click', '.translate-on', function (event) {
                event.preventDefault();
                let href = $(this).data('url');
                $.ajax({
                    type: "GET",
                    url: href,
                    data: {},
                    dataType: "json",
                    beforeSend: function () {
                        $('.loader').removeClass('hidden');
                    },
                    success: function (result) {
                        $('.console-data').html(result.html);
                    },
                    complete: function () {
                        $('.loader').addClass('hidden');
                    },
                    error: function (jqXHR, testStatus, error) {
                        console.log(error);
                        alert("Page " + href + " cannot open. Error:" + error);
                        $('.loader').hide();
                    },
                    //timeout: 8000
                })
            });

            function ajaxTranslate(num){
                event.preventDefault();
                $.ajax({
                    type: "GET",
                    url: 'index.php?route=extension/module/centum_lng_translate/translateajax&token=<?=$token?>&module_id=<?=$module_id?>&num='+num,
                    dataType: "json",
                    beforeSend: function () {
                        $('.loader').removeClass('hidden');
                    },
                    success: function (result) {
                        $('.console-data').append(result.html);
                        if (result.final !== 1) {
                            $('.progress-bar').width(result.percent + '%');
                            ajaxTranslate(result.num);
                        }
                    },
                    complete: function () {
                        $('.loader').addClass('hidden');
                    },
                    error: function (jqXHR, testStatus, error) {
                        console.log(error);
                        alert("Page " + href + " cannot open. Error:" + error);
                        $('.loader').hide();
                    },
                })
            };

            $(document).on('click', '.translate-on-ajax', function (event) {
                ajaxTranslate();
            });


            $(document).on('click', '#console-show-product', function () {
                $(this).val(($(this).val() == 0) ? 1 : 0);
            });

            $(document).on('click', '#cron', function () {
                let copyText = document.getElementById("cron");
                copyText.select();
                copyText.setSelectionRange(0, 99999);
                document.execCommand("copy");
            });

        })(jQuery);
    </script>
    <div class="page-header">
        <div class="container-fluid">

            <!-- Кнопки управления -->
            <div class="pull-right">
                <button class="btn btn-primary translate-on-ajax"
                        data-url="index.php?route=extension/module/centum_lng_translate/translate&token=<?=$token ?>&module_id=<?=$module_id ?>">
                    <?=$text_translate ?><i class="col-xs-offset-1 fa fa-cogs"></i></button>
                <button type="submit" form="form-module" data-toggle="tooltip" title="<?=$button_save ?>"
                        class="btn btn-primary save-module"><i class="fa fa-save"></i></button>
                <a href="<?=$cancel ?>" data-toggle="tooltip" title="<?=$button_cancel ?>" class="btn btn-default"><i
                            class="fa fa-reply"></i></a>
            </div>

            <!-- Название модуля -->
            <h1><?=$heading_title ?></h1>

            <!-- Хлебные крошки -->
            <ul class="breadcrumb">
                <?php
                 foreach($breadcrumbs as $breadcrumb){
                    echo '<li><a href="'.$breadcrumb['href'].'">'.$breadcrumb['text'].'</a></li>';
                }
                ?>
            </ul>

        </div>
    </div>

    <div class="container-fluid">
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title"><i class="fa fa-pencil"></i> <?=$text_edit ?></h3>
            </div>
            <div class="panel-body">
                <form action="<?=$action ?>" method="post" enctype="multipart/form-data" id="form-module"
                      class="form-horizontal">

                    <!-- Настройка: "Название" -->
                    <div class="form-group">
                        <label class="col-sm-2 control-label" for="input-status"><?=$text_name ?></label>
                        <div class="col-sm-10">
                            <input name="name" class="form-control" type="text" value="<?=(isset($name)) ? $name : '' ?>">
                        </div>
                    </div>

                    <!-- Настройка: "Статус" -->
                    <div class="form-group">
                        <label class="col-sm-2 control-label" for="input-status"><?=$text_status ?></label>
                        <div class="col-sm-10">
                            <select name="status" id="input-status" class="form-control">
                                <?php
                                   if($status){
                                    echo '<option value="1" selected="selected">'.$text_enabled.'</option><option value="0"><?=$text_disabled ?></option>';
                                }else{
                                echo '<option value="1">'.$text_enabled.'</option><option value="0" selected="selected">'.$text_disabled.'</option>';
                                }
                                ?>
                            </select>
                        </div>
                    </div>

                    <!-- Настройка: "GOOGLE API Key" -->
                    <div class="form-group">
                        <label class="col-sm-2 control-label" for="input-status">
                            <?= $text_api_key ?>
                            <span data-toggle="tooltip"
                                  title="<?= $api_tooltip ?>">
                            </span>
                        </label>
                        <div class="col-sm-10">
                            <input name="module_centum_lng_translate_api_key" class="form-control" type="text" value="<?=(isset($module_centum_lng_translate_api_key)) ? $module_centum_lng_translate_api_key : ''?>">
                        </div>
                    </div>

                    <!-- Настройка: "Тип перевода" -->
                    <div class="form-group">
                        <label class="col-sm-2 control-label" for="input-type"><?=$text_type ?></label>
                        <div class="col-sm-10">
                            <select name="type" id="input-type" class="form-control" onchange="$('.save-module').click();">
                                <option value="1" <?=(isset($type) && $type == 1) ?'selected': ''?>><?=$text_type_product?></option>>
                                <option value="2" <?=(isset($type) && $type == 2) ?'selected': ''?>><?=$text_type_category?></option>>
                                <option value="3" <?=(isset($type) && $type == 3) ?'selected': ''?>><?=$text_type_attribute?></option>>
                                <option value="4" <?=(isset($type) && $type == 4) ?'selected': ''?>><?=$text_type_product_attribute?></option>>
                            </select>
                        </div>
                    </div>

                    <!-- Настройка: "Язык с которого переводить" -->
                    <div class="form-group">
                        <label class="col-sm-2 control-label"
                               for="input-from-translate"><?=$text_translate_from ?></label>
                        <div class="col-sm-10">
                            <select name="module_centum_lng_translate_from_translate" id="input-from-translate"
                                    class="form-control">
                                <?php
                                foreach($languages as $lng){
                                ?>
                                <option value="<?=$lng['language_id']?>" <?=(isset($module_centum_lng_translate_from_translate) && $module_centum_lng_translate_from_translate == $lng['language_id']) ? 'selected="selected"' : '' ?>><?=$lng['name']?></option>
                                <?php
                                }
                                ?>
                            </select>
                        </div>
                    </div>

                    <!-- Настройка: "Язык на который нужно перевести" -->
                    <div class="form-group">
                        <label class="col-sm-2 control-label" for="input-to-translate"><?=$text_translate_to ?></label>
                        <div class="col-sm-10">
                            <select name="module_centum_lng_translate_to_translate" id="input-to-translate"
                                    class="form-control">
                                <?php
                                foreach($languages as $lng){
                                ?>
                                <option value="<?=$lng['language_id']?>" <?=(isset($module_centum_lng_translate_to_translate) && $module_centum_lng_translate_to_translate == $lng['language_id']) ? 'selected="selected"' : '' ?>><?=$lng['name']?></option>
                                <?php
                                }
                                ?>
                            </select>
                        </div>
                    </div>

                    <!-- Настройка: "Переводить все товары, или только не переведнные" -->
                    <div class="form-group">
                        <label class="col-sm-2 control-label"
                               for="input-translate-all"><?=$label_all_translate ?>
                            <span data-toggle="tooltip"
                                  title="<?=$help_all_translate ?>">
                            </span>
                        </label>
                        <div class="col-sm-10">
                            <select name="module_centum_lng_translate_translate_all_product" id="input-translate-all"
                                    class="form-control">
                                <option value="1" <?=(isset($module_centum_lng_translate_translate_all_product) && $module_centum_lng_translate_translate_all_product == 1) ? 'selected="selected"' : '' ?>>
                                Нет
                                </option>
                                <option value="0" <?=(isset($module_centum_lng_translate_translate_all_product) && $module_centum_lng_translate_translate_all_product == 0) ? 'selected="selected"' : '' ?>>
                                Да
                                </option>
                            </select>
                        </div>
                    </div>

                    <!-- Настройка: "Переводить только в статусе ативен" -->
                    <div class="form-group">
                        <label class="col-sm-2 control-label"
                               for="input-active-only-translate"><?=$label_state_active_only_translate ?>
                            <span data-toggle="tooltip"
                                  title="<?=$help_state_active_only_translate ?>">
                            </span>
                        </label>
                        <div class="col-sm-10">
                            <select name="module_centum_lng_translate_state_active_only_translate"
                                    id="input-active-only-translate" class="form-control">
                                <option value="0" <?=(isset($module_centum_lng_translate_state_active_only_translate) && $module_centum_lng_translate_state_active_only_translate == 0) ? 'selected="selected"' : '' ?>>
                                Нет
                                </option>
                                <option value="1" <?=(isset($module_centum_lng_translate_state_active_only_translate) && $module_centum_lng_translate_state_active_only_translate == 1) ? 'selected="selected"' : '' ?>>
                                Да
                                </option>
                            </select>
                        </div>
                    </div>

                    <!-- Настройка: "Сколько перевести за раз" -->
                    <div class="form-group">
                        <label class="col-sm-2 control-label"
                               for="input-count-in-one-go-translate"><?=$label_count_in_one_go_translate ?>
                            <span data-toggle="tooltip"
                                  title="<?=$help_count_in_one_go_translate ?>">
                            </span>
                        </label>
                        <div class="col-sm-10">
                            <input type="type" name="module_centum_lng_translate_translate_in_one_go"
                                   id="input-count-in-one-go-translate" class="form-control"
                                   value="<?=(isset($module_centum_lng_translate_translate_in_one_go)) ? $module_centum_lng_translate_translate_in_one_go : '' ?>">
                        </div>
                    </div>

                    <?php
                        if((isset($type) && $type == 4)){
                    ?>
                    <!-- Настройка: "Какой атрибут перевести" -->
                    <div class="form-group">
                        <label class="col-sm-2 control-label"
                               for="input-count-in-one-go-translate"><?=$label_translate_product_attribute ?>
                        </label>
                        <div class="col-sm-10">
                            <select class="form-control" name="module_centum_lng_translate_translate_product_attribute" id="module_centum_lng_translate_translate_product_attribute">
                                <?php foreach($attributes as $attribute): ?>
                                <option value="<?= $attribute['attribute_id'] ?>" <?= (isset($module_centum_lng_translate_translate_product_attribute) && ($module_centum_lng_translate_translate_product_attribute == $attribute['attribute_id'])) ? 'selected' : '' ?>><?= $attribute['name'] ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>

                    <!-- Настройка: "Переводить одинаковые атрибуты за один раз" -->
                    <div class="form-group">
                        <label class="col-sm-2 control-label"
                               for="input-translate-attribute-equal"><?=$text_translate_attribute_equal ?>
                            <span data-toggle="tooltip"
                                  title="<?=$help_translate_attribute_equal ?>">
                            </span>
                        </label>
                        <div class="col-sm-10">
                            <select name="module_centum_lng_translate_translate_attribute_equal" id="input-translate-attribute-equal"
                                    class="form-control">
                                <option value="0" <?=(isset($module_centum_lng_translate_translate_attribute_equal) && $module_centum_lng_translate_translate_attribute_equal == 0) ? 'selected="selected"' : '' ?>>
                                Нет
                                </option>
                                <option value="1" <?=(isset($module_centum_lng_translate_translate_attribute_equal) && $module_centum_lng_translate_translate_attribute_equal == 1) ? 'selected="selected"' : '' ?>>
                                Да
                                </option>
                            </select>

                        </div>
                    </div>
                    <?php
                        }
                    ?>

                    <!-- Настройка: "Настойка консоли" -->
                    <div class="panel-heading"><?=$text_console_setting ?></div>
                    <div class="form-group">
                        <label class="col-sm-2 control-label"
                               for="console-show-product"><span data-toggle="tooltip"
                                                                title="<?=$title_console_show_product_need_translate ?>">
                            <?=$label_console_show_product_need_translate ?></span></label>
                        <div class="col-sm-10">
                            <input type="checkbox" name="module_centum_lng_translate_console_show_product"
                                   value="<?=(isset($module_centum_lng_translate_console_show_product)) ? $module_centum_lng_translate_console_show_product : '' ?>"
                            <?=(isset($module_centum_lng_translate_console_show_product) && $module_centum_lng_translate_console_show_product ==1) ? 'checked="checked"' : ''?>
                            id="console-show-product">

                        </div>
                    </div>
                </form>
            </div>
            <div class="panel panel-default">
                <div class="panel-heading">
                    <?=$text_console ?>

                    <div class="loader hidden">
                        <div></div>
                        <div></div>
                        <div></div>
                        <div></div>
                    </div>
                </div>
                <div class="panel-body">
                    <div class="form-group">
                        <div class="form-control well well-sm"
                             style="height: 80px; overflow: auto;"><?=(isset($text_total_not_translated_products_found)) ? $text_total_not_translated_products_found: '' ?> : <?=(isset($search_count_elements)) ? $search_count_elements : ''?><br>
                            <?=$text_cron ?>: <input type="text" style="width:500px;" value="index.php?route=extension/module/centum_lng_translate&module_id=<?=(isset($module_id)) ? $module_id : '' ?>" id="cron"><br>
                            <?php
                               $search_elements = (isset($search_elements)) ? $search_elements : '';

                                if(isset($module_centum_lng_translate_console_show_product) && $module_centum_lng_translate_console_show_product ==1){
                                    echo $text_not_translated_products_found.': '.$search_elements;
                                }
                            ?>
                        </div>
                        <div class="progress">
                            <div class="progress-bar progress-bar-striped" role="progressbar" style="width: 0%" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100"></div>
                        </div>
                    </div>
                    <div class="form-group">
                        <!--<textarea wrap="off" rows="10" readonly="" class="form-control console-data"></textarea>-->
                        <div class="form-control console-data" style="height: 500px; overflow-y: scroll;"></div>
                    </div>
                    <div class="form-group">
                        <button class="btn btn-primary translate-on-ajax"><?=$text_translate ?></button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?=$footer?>