<?php

class ModelExtensionModuleCentumLngTranslate extends Model
{
    public $apiKey;

    public function hasApiKey()
    {

        return !empty($this->apiKey);
    }

    /**
     * Get all product that do not have translation in table product_description
     * For example if exist line with id 1, but not exist with in 2
     * This not actual, because id 2 create automatically
     * However, just in case, left to check this situation
     *
     * @return mixed
     */
    public function getCheckProductsWithOutTranslate()
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "product p 
        LEFT JOIN " . DB_PREFIX . "product_description pd ON (p.product_id = pd.product_id) 
        WHERE pd.language_id = '" . (int)$this->config->get('module_centum_lng_translate_from_translate') . "'
       ";

        /**
         * Get not translated
         */
        if ((int)$this->config->get('module_centum_lng_translate_translate_all_product') === 0) {
            $sql .= "AND pd.product_id NOT IN(
            SELECT product_id FROM " . DB_PREFIX . "product_description 
            WHERE language_id = '" . (int)$this->config->get('module_centum_lng_translate_to_translate') . "'
            )";
        }

        /**
         * Get with status 1 only
         */
        if ((int)$this->config->get('module_centum_lng_translate_state_active_only_translate') === 1) {
            $sql .= "AND p.status = '" . (int)$this->config->get('module_centum_lng_translate_state_active_only_translate') . "'";
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    /**
     * Get the necessary products by comparing the description and meta title, name
     * if they are equal, then translation is needed
     * Create array with product
     *
     * @param integer $idModule
     * @return array
     */
    public function getProductsWithOutTranslate($idModule)
    {
        $this->load->model('extension/module');
        $moduleData = $this->model_extension_module->getModule($idModule);
        $sqlOrder = 'ORDER BY pd.product_id';

        /**
         * Get product from translate
         */
        $sql = "SELECT * FROM " . DB_PREFIX . "product p 
        LEFT JOIN " . DB_PREFIX . "product_description pd ON (p.product_id = pd.product_id) 
        WHERE pd.language_id = '" . (int)$moduleData['module_centum_lng_translate_from_translate'] . "' AND p.translated != 1
       ";

        /**
         * Get with status 1 only
         */
        if ((int)$this->config->get('module_centum_lng_translate_state_active_only_translate') === 1) {
            $sql .= "AND p.status = '" . (int)$moduleData['module_centum_lng_translate_state_active_only_translate'] . "'";
        }

        $sql .= $sqlOrder;
        $query = $this->db->query($sql);
        $fromTranslateRows = $query->rows;
        $fromTranslate = [];

        foreach($fromTranslateRows as $productFromTranslate){
            $fromTranslate[$productFromTranslate['product_id']] = $productFromTranslate;
        }

        /**
         * Get product to translate
         */
        $sql = "SELECT * FROM " . DB_PREFIX . "product p 
        LEFT JOIN " . DB_PREFIX . "product_description pd ON (p.product_id = pd.product_id) 
        WHERE pd.language_id = '" . (int)$moduleData['module_centum_lng_translate_to_translate'] . "' AND p.translated != 1
       ";

        /**
         * Get with status 1 only
         */
        if ((int)$this->config->get('module_centum_lng_translate_state_active_only_translate') === 1) {
            $sql .= "AND p.status = '" . (int)$moduleData['module_centum_lng_translate_state_active_only_translate'] . "'";
        }

        $sql .= $sqlOrder;
        $query = $this->db->query($sql);
        $toTranslateRows = $query->rows;
        $toTranslate = [];

        foreach($toTranslateRows as $productToTranslate){
            $toTranslate[$productToTranslate['product_id']] = $productToTranslate;
        }

        return $this->compareProduct($fromTranslate, $toTranslate, $moduleData);
    }


    /**
     * Get the necessary attribute by comparing the description and meta title, name
     * Create array with attribute
     *
     * @param integer $idModule
     * @return array
     */
    public function getAttributesWithOutTranslate($idModule)
    {
        $this->load->model('extension/module');
        $moduleData = $this->model_extension_module->getModule($idModule);
        $sqlOrder = 'ORDER BY ad.attribute_id';

        /**
         * Get attribute from translate
         */
        $sql = "SELECT * FROM " . DB_PREFIX . "attribute a 
        LEFT JOIN " . DB_PREFIX . "attribute_description ad ON (a.attribute_id = ad.attribute_id) 
        WHERE ad.language_id = '" . (int)$moduleData['module_centum_lng_translate_from_translate'] . "'
       ";

        $sql .= $sqlOrder;
        $query = $this->db->query($sql);
        $fromTranslateRows = $query->rows;
        $fromTranslate = [];

        foreach($fromTranslateRows as $attrFromTranslate){
            $fromTranslate[$attrFromTranslate['attribute_id']] = $attrFromTranslate;
        }

        /**
         * Get attribute to translate
         */
        $sql = "SELECT * FROM " . DB_PREFIX . "attribute a 
        LEFT JOIN " . DB_PREFIX . "attribute_description ad ON (a.attribute_id = ad.attribute_id) 
        WHERE ad.language_id = '" . (int)$moduleData['module_centum_lng_translate_to_translate'] . "'
       ";

        $sql .= $sqlOrder;
        $query = $this->db->query($sql);
        $toTranslateRows = $query->rows;
        $toTranslate = [];

        foreach($toTranslateRows as $productToTranslate){
            $toTranslate[$productToTranslate['attribute_id']] = $productToTranslate;
        }

        return $this->compareAttribute($fromTranslate, $toTranslate, $moduleData);
    }

    /**
     * Get the necessary categories by comparing the description and meta title, name
     * if they are equal, then translation is needed
     * Create array with category
     *
     * @param integer $idModule
     * @return array
     */
    public function getCategoriesWithOutTranslate($idModule)
    {
        $this->load->model('extension/module');
        $moduleData = $this->model_extension_module->getModule($idModule);
        $sqlOrder = 'ORDER BY cd.category_id';

        /**
         * Get category from translate
         */
        $sql = "SELECT * FROM " . DB_PREFIX . "category c 
        LEFT JOIN " . DB_PREFIX . "category_description cd ON (c.category_id = cd.category_id) 
        WHERE cd.language_id = '" . (int)$moduleData['module_centum_lng_translate_from_translate'] . "'
       ";

        /**
         * Get with status 1 only
         */
        if ((int)$this->config->get('module_centum_lng_translate_state_active_only_translate') === 1) {
            $sql .= "AND c.status = '" . (int)$moduleData['module_centum_lng_translate_state_active_only_translate'] . "'";
        }

        $sql .= $sqlOrder;
        $query = $this->db->query($sql);
        $fromTranslateRows = $query->rows;
        $fromTranslate = [];

        foreach($fromTranslateRows as $productFromTranslate){
            $fromTranslate[$productFromTranslate['category_id']] = $productFromTranslate;
        }

        /**
         * Get category to translate
         */
        $sql = "SELECT * FROM " . DB_PREFIX . "category c
        LEFT JOIN " . DB_PREFIX . "category_description cd ON (c.category_id = cd.category_id) 
        WHERE cd.language_id = '" . (int)$moduleData['module_centum_lng_translate_to_translate'] . "'
       ";

        /**
         * Get with status 1 only
         */
        if ((int)$this->config->get('module_centum_lng_translate_state_active_only_translate') === 1) {
            $sql .= "AND c.status = '" . (int)$moduleData['module_centum_lng_translate_state_active_only_translate'] . "'";
        }

        $sql .= $sqlOrder;
        $query = $this->db->query($sql);
        $toTranslateRows = $query->rows;
        $toTranslate = [];

        foreach($toTranslateRows as $categoryToTranslate){
            $toTranslate[$categoryToTranslate['category_id']] = $categoryToTranslate;
        }

        return $this->compareCategories($fromTranslate, $toTranslate, $moduleData);
    }

    /**
     * Save the translated data
     * Just in case, if the database already contains 2 matching values,
     * delete everything with the specified id, and then create a new translation
     *
     * @param integer $idModule
     * @param integer $num
     * @return string
     */
    public function setProductsWithOutTranslate($idModule, $num)
    {
        $this->load->model('extension/module');
        $moduleData = $this->model_extension_module->getModule($idModule);
        $lineInfo = 'Module off <br>';

        if ((int)$moduleData['status'] === 1) {
            $products = $this->getProductsWithOutTranslate($idModule);
            $this->load->model('localisation/language');
            $lngFrom = $this->model_localisation_language->getLanguage((int)$moduleData['module_centum_lng_translate_from_translate']);
            $lngTo = $this->model_localisation_language->getLanguage((int)$moduleData['module_centum_lng_translate_to_translate']);
            $lineInfo = '';
            //$this->checkAlreadyExistsTranslate();
            $info = (isset($products[$num]['info'])) ? $products[$num]['info'] : null;
            $stripDescription = preg_replace('/(?:<|&lt;).*?(?:>|&gt;)/', ' ',$products[$num]['description']);
            $stripDescription = mb_strimwidth($stripDescription,0 , 700, '...');
            $toGoogleTranslateArray = [
                'product_id' => $products[$num]['product_id'],
                'name' => strip_tags(html_entity_decode($products[$num]['name'])),
                'description' => iconv(mb_detect_encoding($stripDescription, mb_detect_order(), true), 'UTF-8', $stripDescription),
                'tag' => $products[$num]['tag'],
                'meta_title' => strip_tags(html_entity_decode($products[$num]['meta_title'])),
                'meta_description' => $products[$num]['meta_description'],
                'meta_keyword' => $products[$num]['meta_keyword'],
                'translated' => $products[$num]['translated'],
                'info' => $info,
            ];
//            $lineInfo .=$toGoogleTranslateArray['description'];
//   die;
            $fromGoogleTranslateArray = $this->translateGoogle($lngFrom['code'], $lngTo['code'], $toGoogleTranslateArray);
            $error = (count($this->compareProduct([$fromGoogleTranslateArray],[$toGoogleTranslateArray], $moduleData)) === 0) ? '<span class="text-success">: ok</span>' : '<span class="text-danger">: перевод совпал с исходным текстом</span>';
            $lineInfo .= '<p>ID ' . $this->getUrlToProduct([$products[$num]], ' ', true) . $error . "</p>\n";

            $this->db->query("DELETE FROM " . DB_PREFIX . "product_description WHERE product_id = '" . (int)$products[$num]['product_id'] . "' AND language_id = '" . (int)$moduleData['module_centum_lng_translate_to_translate'] . "'");

            $sql = "INSERT INTO " . DB_PREFIX . "product_description
                SET product_id = '" . (int)$products[$num]['product_id'] . "',
                 language_id = '" . (int)$moduleData['module_centum_lng_translate_to_translate'] . "',
                 name = '" . $this->db->escape($fromGoogleTranslateArray['name']) . "',
                 description = '" . $this->db->escape($fromGoogleTranslateArray['description']) . "',
                 tag = '" . $this->db->escape($fromGoogleTranslateArray['tag']) . "',
                 meta_title = '" . $this->db->escape($fromGoogleTranslateArray['meta_title']) . "',
                 meta_description = '" . $this->db->escape($fromGoogleTranslateArray['meta_description']) . "',
                 meta_keyword = '" . $this->db->escape($fromGoogleTranslateArray['meta_keyword']) . "'";

            if (!empty($info)) {
                $sql .= "'info = '" . $this->db->escape($fromGoogleTranslateArray['info']) . "'";
            }

            $this->db->query($sql);

            $this->db->query("UPDATE " . DB_PREFIX . "product SET translated = 1 WHERE product_id = '" . (int)$products[$num]['product_id'] . "' ");
        }

        return $lineInfo;
    }

    /**
     * Save the translated data
     * delete everything with the specified id, and then create a new translation
     *
     * @param integer $idModule
     * @param integer $num
     * @return string
     */
    public function setAttributesWithOutTranslate($idModule, $num)
    {
        $this->load->model('extension/module');
        $moduleData = $this->model_extension_module->getModule($idModule);
        $lineInfo = 'Module off';

        if ((int)$moduleData['status'] === 1) {
            $this->load->model('localisation/language');
            $attributes = $this->getAttributesWithOutTranslate($idModule);
            $lngFrom = $this->model_localisation_language->getLanguage((int)$moduleData['module_centum_lng_translate_from_translate']);
            $lngTo = $this->model_localisation_language->getLanguage((int)$moduleData['module_centum_lng_translate_to_translate']);
            $toGoogleTranslateArray = [
                'attribute_id' => $attributes[$num]['attribute_id'],
                'name' => htmlspecialchars_decode($attributes[$num]['name']),
            ];
            $fromGoogleTranslateArray = $this->translateGoogle($lngFrom['code'], $lngTo['code'], $toGoogleTranslateArray);
            $error = (count($this->compareAttribute([$toGoogleTranslateArray], [$fromGoogleTranslateArray], $moduleData)) === 0) ? '<span class="text-success">: ok</span>' : '<span class="text-danger">: перевод совпал с исходным текстом</span>';
            $resTranslate = $fromGoogleTranslateArray['name'];
            $lineInfo = '<p>ID ' . $this->getUrlToAttribute([$attributes[$num]], ' ', true) .' -> '. $resTranslate .' '. $error ."</p>\n";

            $this->db->query("DELETE FROM " . DB_PREFIX . "attribute_description WHERE attribute_id = '" . (int)$attributes[$num]['attribute_id'] . "' AND language_id = '" . (int)$moduleData['module_centum_lng_translate_to_translate'] . "'");

            $sql = "INSERT INTO " . DB_PREFIX . "attribute_description
                    SET attribute_id = '" . (int)$attributes[$num]['attribute_id'] . "',
                    language_id = '" . (int)$moduleData['module_centum_lng_translate_to_translate'] . "',
                    name = '" . $this->db->escape($fromGoogleTranslateArray['name']) . "'";

            $this->db->query($sql);

            if ((int)$moduleData['module_centum_lng_translate_translate_attribute_equal'] == 1) {
                $this->db->query("UPDATE " . DB_PREFIX . "attribute_description 
            SET name = '" . $this->db->escape($fromGoogleTranslateArray['name']) . "'
            WHERE name = '" . $attributes[$num]['name'] . "' 
            AND language_id = '" . (int)$moduleData['module_centum_lng_translate_to_translate'] . "'"
                );
            }
        }

        return $lineInfo;

    }

    /**
     * Save the translated data category
     * delete everything with the specified id, and then create a new translation
     *
     * @param integer $idModule
     * @param integer $num
     * @return string
     */
    public function setCategoriesWithOutTranslate($idModule, $num)
    {
        $this->load->model('extension/module');
        $moduleData = $this->model_extension_module->getModule($idModule);
        $lineInfo = 'Module off';

        if ((int)$moduleData['status'] === 1) {
            $categories = $this->getCategoriesWithOutTranslate($idModule);
            $this->load->model('localisation/language');
            $lngFrom = $this->model_localisation_language->getLanguage((int)$moduleData['module_centum_lng_translate_from_translate']);
            $lngTo = $this->model_localisation_language->getLanguage((int)$moduleData['module_centum_lng_translate_to_translate']);
            $lineInfo = '';
            $stripDescription = preg_replace('/(?:<|&lt;).*?(?:>|&gt;)/', ' ',$categories[$num]['description']);
            $stripDescription = mb_strimwidth($stripDescription,0 , 700, '...');
            $toGoogleTranslateArray = [
                'category_id' => $categories[$num]['category_id'],
                'name' => strip_tags(html_entity_decode($categories[$num]['name'])),
                'description' => iconv(mb_detect_encoding($stripDescription, mb_detect_order(), true), 'UTF-8', $stripDescription),
                'meta_title' => strip_tags(html_entity_decode($categories[$num]['meta_title'])),
                'meta_description' => $categories[$num]['meta_description'],
                'meta_keyword' => $categories[$num]['meta_keyword'],
            ];
            $fromGoogleTranslateArray = $this->translateGoogle($lngFrom['code'], $lngTo['code'], $toGoogleTranslateArray);
            $error = (count($this->compareCategories([$toGoogleTranslateArray], [$fromGoogleTranslateArray], $moduleData)) === 0) ? '<span class="text-success">: ok</span>' : '<span class="text-danger">: перевод совпал с исходным текстом</span>';
            $lineInfo .= '<p>ID ' . $this->getUrlToCategory([$categories[$num]], ' ', true) . $error . "</p>\n";

            $this->db->query("DELETE FROM " . DB_PREFIX . "category_description WHERE category_id = '" . (int)$categories[$num]['category_id'] . "' AND language_id = '" . (int)$moduleData['module_centum_lng_translate_to_translate'] . "'");

            $sql = "INSERT INTO " . DB_PREFIX . "category_description
                SET category_id = '" . (int)$categories[$num]['category_id'] . "',
                 language_id = '" . (int)$moduleData['module_centum_lng_translate_to_translate'] . "',
                 name = '" . $this->db->escape($fromGoogleTranslateArray['name']) . "',
                 description = '" . $this->db->escape($fromGoogleTranslateArray['description']) . "',
                 meta_title = '" . $this->db->escape($fromGoogleTranslateArray['meta_title']) . "',
                 meta_description = '" . $this->db->escape($fromGoogleTranslateArray['meta_description']) . "',
                 meta_keyword = '" . $this->db->escape($fromGoogleTranslateArray['meta_keyword']) . "'";

            $this->db->query($sql);
        }

        return $lineInfo;
    }

    public function setProductAttributesWithOutTranslate($idModule, $num)
    {
        $res = '';
        $this->load->model('extension/module');
        $this->load->model('localisation/language');
        $moduleData = $this->model_extension_module->getModule($idModule);
        $lineInfo = 'Module off';

        $lngFrom = $this->model_localisation_language->getLanguage((int)$moduleData['module_centum_lng_translate_from_translate']);
        $lngTo = $this->model_localisation_language->getLanguage((int)$moduleData['module_centum_lng_translate_to_translate']);
        $attributeId = (int)$moduleData['module_centum_lng_translate_translate_product_attribute'];

        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_attribute pa WHERE language_id = '". (int)$moduleData['module_centum_lng_translate_from_translate'] ."' AND attribute_id = '". (int)$attributeId ."' AND translated IS NULL LIMIT ". (int)$moduleData['module_centum_lng_translate_translate_in_one_go'] );

        foreach ($query->rows as $productAttribute) {

            $toGoogleTranslateArray = [
                'text' => $productAttribute['text']
            ];

            $fromGoogleTranslateArray = $this->translateGoogle($lngFrom['code'], $lngTo['code'], $toGoogleTranslateArray);

            $text = mb_strtoupper(mb_substr($fromGoogleTranslateArray['text'],0,1)) . mb_substr($fromGoogleTranslateArray['text'],1);

            $this->db->query("UPDATE " . DB_PREFIX . "product_attribute SET text = '". $text ."', translated = 1 WHERE product_id = '". $productAttribute['product_id'] ."' AND attribute_id = '". $productAttribute['attribute_id'] ."' AND language_id = '". (int)$moduleData['module_centum_lng_translate_to_translate'] ."' ");
            $this->db->query("UPDATE " . DB_PREFIX . "product_attribute SET translated = 1 WHERE product_id = '". $productAttribute['product_id'] ."' AND attribute_id = '". $productAttribute['attribute_id'] ."' AND language_id = '". (int)$moduleData['module_centum_lng_translate_from_translate'] ."' ");
            $res .= 'Атрибут товара ' .  $productAttribute['product_id'] . ' переведен <br>';

        }

        return $res;

    }

    /**
     * Direct comparison of language versions
     *
     * @param array $fromTranslate
     * @param array $toTranslate
     * @param array $moduleData
     * @return array
     */
    public function compareProduct(array $fromTranslate, array $toTranslate, array $moduleData)
    {
        $needTranslate = [];

        foreach ($fromTranslate as $key => $product) {
            if(isset($toTranslate[$key]['product_id'])) {
                if ($product['product_id'] === $toTranslate[$key]['product_id']) {
                    if (
//                        (md5($product['description']) === md5($toTranslate[$key]['description'])) &&
//                        (md5($product['meta_title']) === md5($toTranslate[$key]['meta_title'])) &&
//                        (md5($product['name']) === md5($toTranslate[$key]['name'])) &&
                        $product['translated'] != 1
//                        $toTranslate[$key]['translated'] != 1
                    ) {
                        $needTranslate[] = $product;
                    } else {
                        if ((int)$moduleData['module_centum_lng_translate_translate_all_product'] === 1) {
                            $needTranslate[] = $product;
                        }
                    }
                }
            }else{
                $needTranslate[] = $product;
            }
        }

        return $needTranslate;
    }

    /**
     * Direct comparison of language versions for attribute
     *
     * @param array $fromTranslate
     * @param array $toTranslate
     * @param array $moduleData
     * @return array
     */
    public function compareAttribute(array $fromTranslate, array $toTranslate, array $moduleData)
    {
        $needTranslate = [];

        foreach ($fromTranslate as $key => $attr) {
            if(isset($toTranslate[$key]['attribute_id'])) {
                if ($attr['attribute_id'] === $toTranslate[$key]['attribute_id']) {
                    if (md5($attr['name']) === md5($toTranslate[$key]['name'])) {
                        $needTranslate[] = $attr;
                    } else {
                        if ((int)$moduleData['module_centum_lng_translate_translate_all_product'] === 1) {
                            $needTranslate[] = $attr;
                        }
                    }
                }
            }else{
                $needTranslate[] = $attr;
            }
        }

        return $needTranslate;
    }

    /**
     * Direct comparison of language versions category
     *
     * @param array $fromTranslate
     * @param array $toTranslate
     * @param array $moduleData
     * @return array
     */
    public function compareCategories(array $fromTranslate, array $toTranslate, array $moduleData)
    {
        $needTranslate = [];

        foreach ($fromTranslate as $key => $category) {
            if(isset($toTranslate[$key]['category_id'])) {
                if ($category['category_id'] === $toTranslate[$key]['category_id']) {
                    if (
                        (md5($category['description']) === md5($toTranslate[$key]['description'])) &&
                        (md5($category['meta_title']) === md5($toTranslate[$key]['meta_title'])) &&
                        (md5($category['name']) === md5($toTranslate[$key]['name']))
                    ) {
                        $needTranslate[] = $category;
                    } else {
                        if ((int)$moduleData['module_centum_lng_translate_translate_all_product'] === 1) {
                            $needTranslate[] = $category;
                        }
                    }
                }
            }else{
                $needTranslate[] = $category;
            }
        }

        return $needTranslate;
    }

    /**
     * Generating url to product with id and name
     *
     * @param $products
     * @param string $delimiter
     * @param false $name
     * @return string
     */
    public function getUrlToProduct($products, $delimiter = ' ', $name = false)
    {
        $url = '';

        foreach ($products as $product) {
            $productName = ($name === true) ? htmlspecialchars_decode($product['name']) : null;
            $url .= '<a href="' . $this->url->link('catalog/product/edit', 'token=' . $this->session->data['token'] . '&product_id=' . $product['product_id'] . '" target="_blank">' . $product['product_id'] . ' ' . $productName . '</a>' . $delimiter, true);
        }

        return $url;
    }

    /**
     * Generating url to attributes with id and name
     *
     * @param $attributes
     * @param string $delimiter
     * @param false $name
     * @return string
     */
    public function getUrlToAttribute($attributes, $delimiter = ' ', $name = false)
    {
        $url = '';

        foreach ($attributes as $attr) {
            $attrName = ($name === true) ? htmlspecialchars_decode($attr['name']) : null;
            $url .= '<a href="' . $this->url->link('catalog/attribute/edit', 'token=' . $this->session->data['token'] . '&attribute_id=' . $attr['attribute_id'] . '" target="_blank">' . $attr['attribute_id'] . ' ' . $attrName . '</a>' . $delimiter, true);
        }

        return $url;
    }

    /**
     * Generating url to category with id and name
     *
     * @param $categories
     * @param string $delimiter
     * @param false $name
     * @return string
     */
    public function getUrlToCategory($categories, $delimiter = ' ', $name = false)
    {
        $url = '';

        foreach ($categories as $cat) {
            $attrName = ($name === true) ? htmlspecialchars_decode($cat['name']) : null;
            $url .= '<a href="' . $this->url->link('catalog/category/edit', 'token=' . $this->session->data['token'] . '&category_id=' . $cat['category_id'] . '" target="_blank">' . $cat['category_id'] . ' ' . $attrName . '</a>' . $delimiter, true);
        }

        return $url;
    }

    /**
     * IN DEVELOPING
     * Check cache for not duplicate
     * @param $translate
     * @return mixed
     */
    public function checkAlreadyExistsTranslate($translate)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "product_description  WHERE " . $translate['field'] . " = '" . $translate['text'] . "'";
        $query = $this->db->query($sql);

        return $query->rows;
    }

    /**
     * First install
     * Add fields in table 'product' for check state product. If switcher 1 then skipping the product for translation
     * Create test module, for clarity
     */
    public function install()
    {
        $sql = "ALTER TABLE `" . DB_PREFIX . "product`  ADD translated INT NOT NULL DEFAULT(0)";
        $query = $this->db->query($sql);

        $sql = "INSERT INTO " . DB_PREFIX . "module
                SET name = 'Test translate',
                 code = 'centum_lng_translate',
                 setting = '{\"name\":\"Test translate\",\"status\":\"0\",\"module_centum_lng_translate_api_key\":\"\",\"type\":\"1\",\"module_centum_lng_translate_from_translate\":\"1\",\"module_centum_lng_translate_to_translate\":\"2\",\"module_centum_lng_translate_translate_attribute_equal\":\"0\",\"module_centum_lng_translate_translate_all_product\":\"1\",\"module_centum_lng_translate_state_active_only_translate\":\"0\",\"module_centum_lng_translate_translate_in_one_go\":\"10\",\"module_centum_lng_translate_translate_product_attribute\":\"4\"}'";
        $this->db->query($sql);
    }

    public function uninstall()
    {
        $sql = "ALTER TABLE `" . DB_PREFIX . "product`  DROP COLUMN translated";
        $query = $this->db->query($sql);
    }

    /**
     * Dump of the JSON's response in an array.
     *
     * @param string $json
     * @return string
     */
    protected static function getSentencesFromJSON($json)
    {
        $arr = json_decode($json, true);
        $sentences = '';

        if (isset($arr['sentences'])) {
            foreach ($arr['sentences'] as $s) {
                $sentences .= isset($s['trans']) ? $s['trans'] : '';
            }
        }

        return $sentences;
    }

    /**
     * Curl Request attempts connecting on failure.
     *
     * @param string $url
     * @param array $fields
     * @param string $fields_string
     * @param int $i
     * @param int $attempts
     *
     * @return string
     */
    protected static function curlRequest($url, $fields, $fields_string, $i, $attempts)
    {
        $i++;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, count($fields));
        curl_setopt($ch, CURLOPT_POSTFIELDS, $fields_string);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_ENCODING, 'UTF-8');
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        //curl_setopt($ch, CURLOPT_HEADER, true);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 15);
        curl_setopt($ch, CURLOPT_USERAGENT, 'AndroidTranslate/5.3.0.RC02.130475354-53000263 5.1 phone TRANSLATE_OPM5_TEST_1');

        $result = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

        if (false === $result || 200 !== $httpcode) {
            // echo $i,'/',$attempts,' Aborted, trying again... ',curl_error($ch),PHP_EOL;

            if ($i >= $attempts) {
                //echo 'Could not connect and get data.',PHP_EOL;
                return;
                //die('Could not connect and get data.'.PHP_EOL);
            } else {
                // timeout 1.5 sec
                usleep(1500000);

                return self::curlRequest($url, $fields, $fields_string, $i, $attempts);
            }
        } else {
            return $result; //self::getBodyCurlResponse();
        }
        curl_close($ch);
    }

    /**
     * Make string with post data fields.
     *
     * @param array $fields
     * @return string
     */
    protected static function fieldsString($fields)
    {
        $fields_string = '';
        foreach ($fields as $key => $value) {
            $fields_string .= $key . '=' . $value . '&';
        }

        return rtrim($fields_string, '&');
    }


    private function translateGoogle($source, $target, $text, $attempts = 5, $apiKey = null)
    {
        if (is_array($text)) {
            $translation = self::requestTranslationArray($source, $target, $text, $attempts = 5);
        } else {
            $translation = self::requestTranslation($source, $target, $text, $attempts = 5);
        }

        return $translation;
    }

    /**
     * @param string $source
     * @param string $target
     * @param array $text
     * @param int $attempts
     *
     * @return array
     */
    private function requestTranslationArray($source, $target, $text, $attempts)
    {
        $arr = [];

        foreach ($text as $key => $value) {
            usleep(500000);
            $arr[$key] = self::requestTranslation($source, $target, $value, $attempts = 5);
        }

        return $arr;
    }

    /**
     * @param string $source
     * @param string $target
     * @param string $text
     * @param int $attempts
     *
     * @return string
     */
    private function requestTranslation($source, $target, $text, $attempts)
    {
        $this->load->model('extension/module');
        $moduleData = $this->model_extension_module->getModule($this->request->get['module_id']);

        $this->apiKey = $moduleData['module_centum_lng_translate_api_key'];

        if ($this->hasApiKey()) {
            return $this->requestTranslationWithApiKey($source, $target, $text, $attempts);
        }

        return $this->requestTranslationWithMobileApi($source, $target, $text, $attempts);
    }

    private function requestTranslationWithApiKey($source, $target, $text, $attempts)
    {
        if (empty($text) || is_numeric($text)) {
            return $text;
        }

        $base = 'https://translation.googleapis.com/language/translate/v2';

        $params = [
            'key' => $this->apiKey,
            'source' => strstr($source, '-', true),
            'target' => strstr($target, '-', true),
            'q'  => $text
        ];

        $url = $base . '?' . http_build_query($params);

        $content = self::curlRequest($url, $params, '', 0, $attempts);

        if ($content) {
            $data = json_decode($content, true);
            return $data['data']['translations'][0]['translatedText'];
        }

        return '';
    }

    private function requestTranslationWithMobileApi($source, $target, $text, $attempts)
    {
        $url = 'https://translate.google.com/translate_a/single?client=at&dt=t&dt=ld&dt=qca&dt=rm&dt=bd&dj=1&hl=uk-RU&ie=UTF-8&oe=UTF-8&inputm=2&otf=2&iid=1dd3b944-fa62-4b55-b330-74909a99969e';

        $fields = [
            'sl' => urlencode($source),
            'tl' => urlencode($target),
            'q' => urlencode($text),
        ];

        if (strlen($fields['q']) >= 5000) {
            //throw new \Exception('Maximum number of characters exceeded: 5000');
            $fields['q'] = substr($fields['q'], 0, 4995);
        }
        // URL-ify the data for the POST
        $fields_string = self::fieldsString($fields);

        $content = self::curlRequest($url, $fields, $fields_string, 0, $attempts);

        if (null === $content) {
            //echo $text,' Error',PHP_EOL;
            return '';
        } else {
            // Parse translation
            return self::getSentencesFromJSON($content);
        }
    }
}
