<?php

class ControllerExtensionModuleCentumLngTranslate extends Controller
{

    public function install()
    {
        $this->load->model('extension/module/centum_lng_translate');
        $this->model_extension_module_centum_lng_translate->install();
    }

    public function uninstall()
    {
        $this->load->model('extension/module/centum_lng_translate');
        $this->model_extension_module_centum_lng_translate->uninstall();
    }

    /**
     * Load the model of the module and setting/module model for save data
     * Saving module settings when the user clicked Save
     * Load the settings via the model method
     */
    public function index()
    {
        /**
         * Get model centum translate for translate product
         * Get standard model for save and restore setting
         * If post then save new or restore module
         */
        $this->load->model('extension/module/centum_lng_translate');
        $this->load->model('setting/setting');
        $this->load->model('extension/module');

        if (($this->request->server['REQUEST_METHOD'] == 'POST')) {
            if (!isset($this->request->get['module_id'])) {
                $this->model_extension_module->addModule('centum_lng_translate', $this->request->post);
                $this->response->redirect($this->url->link('extension/extension', 'token=' . $this->session->data['token'] . '&type=module', true));
                $this->session->data['success'] = 'Модуль создан успешно';
            } else {
                $this->model_extension_module->editModule($this->request->get['module_id'], $this->request->post);
                $this->response->redirect($this->url->link('extension/module/centum_lng_translate', 'token=' . $this->session->data['token'] . '&type=module' . '&module_id=' . $this->request->get['module_id'], true));
                $this->session->data['success'] = 'Настройки модуля сохранены';
            }
        }

        /**
         * All data module
         * Contains variables for the template
         */
        $data = [];
        $moduleData = [];

        /**
         * Get user token from session and number of elements to be translated
         */
        $data['token'] = $this->session->data['token'];

        if (isset($this->request->get['module_id'])) {
            $moduleData = $this->model_extension_module->getModule($this->request->get['module_id']);
            $data['module_id'] = $this->request->get['module_id'];

            if ($moduleData['type'] == 1) {
                $productNeedTranslate = $this->model_extension_module_centum_lng_translate->getProductsWithOutTranslate($this->request->get['module_id']);
                $data['search_count_elements'] = count($productNeedTranslate);

                if ($data['search_count_elements'] > 0) {
                    $data['search_elements'] = $this->model_extension_module_centum_lng_translate->getUrlToProduct($productNeedTranslate, ', ');
                }
            }elseif($moduleData['type'] == 2) {
                $categoryNeedTranslate = $this->model_extension_module_centum_lng_translate->getCategoriesWithOutTranslate($this->request->get['module_id']);
                $data['search_count_elements'] = count($categoryNeedTranslate);

                if ($data['search_count_elements'] > 0) {
                    $data['search_elements'] = $this->model_extension_module_centum_lng_translate->getUrlToCategory($categoryNeedTranslate,', ');
                }
            }else{
                $attributeNeedTranslate = $this->model_extension_module_centum_lng_translate->getAttributesWithOutTranslate($this->request->get['module_id']);
                $data['search_count_elements'] = count($attributeNeedTranslate);

                if ($data['search_count_elements'] > 0) {
                    $data['search_elements'] = $this->model_extension_module_centum_lng_translate->getUrlToAttribute($attributeNeedTranslate, ', ');
                }
            }

            $data['action'] = $this->url->link('extension/module/centum_lng_translate', 'token=' . $this->session->data['token'] . '&module_id=' . $this->request->get['module_id'], true);
        }else{
            $data['action'] = $this->url->link('extension/module/centum_lng_translate', 'token=' . $this->session->data['token'], true);
        }

        $data += $moduleData;
        $data += $this->load->language('extension/module/centum_lng_translate');
        $data += $this->GetBreadCrumbs();

        $this->load->model('catalog/attribute');
        $data['attributes'] = $this->model_catalog_attribute->getAttributes();

        $this->document->setTitle($this->language->get('heading_title'));

        /**
         * get the languages that are activated in the system
         */
        $this->load->model('localisation/language');
        $data['languages'] = $this->model_localisation_language->getLanguages();

        /**
         * Button and part site
         */
        $data['cancel'] = $this->url->link('extension/extension', 'token=' . $this->session->data['token'] . '&type=module', true);
        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        /**
         * Send templates with all module variables
         */
        $this->response->setOutput($this->load->view('extension/module/centum_lng_translate', $data));
    }

    /**
     * no used, translate without ajax
     */
    public function translate()
    {
        $this->load->model('extension/module/centum_lng_translate');
        $this->load->model('extension/module');
        $moduleData = $this->model_extension_module->getModule($this->request->get['module_id']);

        if ($moduleData['type'] == 1) {
            $res['html'] = $this->model_extension_module_centum_lng_translate->setProductsWithOutTranslate($this->request->get['module_id']);
        }else{
            $res['html'] = $this->model_extension_module_centum_lng_translate->setAttributesWithOutTranslate($this->request->get['module_id']);
        }

        echo json_encode($res);
    }

    public function translateAjax()
    {
        $this->load->model('extension/module/centum_lng_translate');
        $this->load->model('extension/module');
        $moduleData = $this->model_extension_module->getModule($this->request->get['module_id']);
        $countInOneGo = (int)$moduleData['module_centum_lng_translate_translate_in_one_go'];
        $res = [];
        $num = ($this->request->get['num'] != 'undefined') ? $this->request->get['num'] : $countInOneGo;
        $this->model_extension_module_centum_lng_translate->apiKey = $moduleData['module_centum_lng_translate_api_key'];

        if ($num > 0) {
            if ($moduleData['type'] == 1) {
                $res['html'] = $this->model_extension_module_centum_lng_translate->setProductsWithOutTranslate($this->request->get['module_id'], $num - 1);
            } elseif ($moduleData['type'] == 2) {
                $res['html'] = $this->model_extension_module_centum_lng_translate->setCategoriesWithOutTranslate($this->request->get['module_id'], $num - 1);
            } elseif ($moduleData['type'] == 3) {
                $res['html'] = $this->model_extension_module_centum_lng_translate->setAttributesWithOutTranslate($this->request->get['module_id'], $num - 1);
            } else {
                $res['html'] = $this->model_extension_module_centum_lng_translate->setProductAttributesWithOutTranslate($this->request->get['module_id'], $num - 1);
            }

            $res['num'] = $num - 1;
            $res['percent'] = ceil(100- (100 * $res['num'] / $countInOneGo));
            $res['final'] = 0;
        } else {
            $res['final'] = 1;
            $res['percent'] = 100;
        }

        echo json_encode($res);
    }

    private function GetBreadCrumbs()
    {
        $data = array();
        $data['breadcrumbs'] = array();
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], true)
        );
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_extension'),
            'href' => $this->url->link('extension/extension', 'token=' . $this->session->data['token'] . '&type=module', true)
        );
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('extension/module/centum_lng_translate', 'token=' . $this->session->data['token'], true)
        );

        return $data;
    }
}