<?php
/**
 * hook admin menu
 */
add_action( 'admin_menu', 'centum_addition_config_menu' );

/**
 * add new menu element
 */
function centum_addition_config_menu()
{
    add_menu_page(
        'Additional theme customization from centum-d',
        'Config Centum',
        'manage_options',
        'centum-addition-config/includes/centum-addition-config-page.php'
    );
}

/**
 * Registering the settings.
 * Settings will be stored in an array, not one setting = one option.
 */
add_action('admin_init', 'plugin_centum_config_settings');
function plugin_centum_config_settings(){
    register_setting( 'option_group_addition_config_centum', 'option_addition_config_centum', 'sanitize_callback' );
    add_settings_section( 'section_id', '', '', 'centum_config_page' );
    add_settings_field('addition_css_centum', 'Addition css', 'addition_css', 'centum_config_page', 'section_id' );
    add_settings_field('addition_on_off', 'Enabling all functions', 'addition_on_off', 'centum_config_page', 'section_id' );
}

/**
 * add section custom css to setting page
 */
function addition_css(){
    $val = get_option('option_addition_config_centum');
    $val = $val ? $val['css'] : null;
    ?>
    <textarea rows="20" cols="100" name="option_addition_config_centum[css]" value="<?php echo esc_attr( $val ) ?>"><?php echo esc_attr( $val ) ?></textarea>
    <?php
}

function addition_on_off(){
    $val = get_option('option_addition_config_centum');
    $val = $val ? $val['onoff'] : null;
    ?>
    <label><input type="checkbox" name="option_addition_config_centum[onoff]" value="1" <?php checked( 1, $val ) ?> />
        On/Off (add text to button "Add to cart", auto coupon application, limits custom field 500, add vendore name to shipstation  )
    </label>
    <?php
}

function sanitize_callback( $options ){

    foreach( $options as $name => & $val ){
        if( $name == 'input' )
            $val = strip_tags( $val );

        if( $name == 'checkbox' )
            $val = intval( $val );
    }

    return $options;
}

/**
 * add custom css to front page
 */
add_action('wp_head','insert_custom_css');

function insert_custom_css() {
    $onOff = get_option('option_addition_config_centum');
    $onOff = $onOff ? $onOff['onoff'] : null;

    if(!is_null($onOff)){
        $val = get_option('option_addition_config_centum');
        $val = $val ? $val['css'] : null;
        echo "\n".'<style type="text/css">'.$val.'</style>';
    }
}